import time
import numpy as np
from numba import jit
from numba import prange
from numba import vectorize

def SoucetPole(A,B,C):
# soucet pole bez jit.funkce baliku NUMBA    
    if A.size == B.size:    
        for i in range(A.size):
            C[i] = A[i]+B[i]
    else:
        print('shape error')    
    return C

@jit
def SoucetPoleJIT(A,B,C):
# soucet pole pomoci jednoduchejit funkce baliku NUMBA
    if A.size == B.size:    
        for i in range(A.size):
            C[i] = A[i]+B[i]
    else:
        print('shape error')        
    return C

@jit(parallel=True)
def SoucetPoleParJIT(A,B,C):
# soucet pole pomoci jednoduchejit funkce baliku NUMBA
    if A.size == B.size:    
        for i in prange(A.size):
            C[i] = A[i]+B[i]
    else:
        print('shape error')        
    return C

@vectorize
def SoucetPoleVectorize(A,B):
    return A+B

N=int(1e7)

A = np.random.randint(low=1,high=5,size=N)
B = np.random.randint(low=1,high=5,size=N)
C = np.zeros(N)

tic=time.time()
C=SoucetPole(A,B,C)
toc=time.time()
print('elapsed time',toc-tic)

tic=time.time()
Cjit=SoucetPoleJIT(A,B,C)
toc=time.time()
print('elapsed time JIT',toc-tic)

tic=time.time()
Cparjit=SoucetPoleParJIT(A,B,C)
toc=time.time()
print('elapsed time parallel JIT',toc-tic)

tic=time.time()
Cvect=SoucetPoleVectorize(A,B)
toc=time.time()
print('elapsed time vectorize',toc-tic)

#print(C,Cjit,Cparjit,Cvect)
