import time
import numpy as np
from numba import cuda, vectorize, jit

def NasobeniMaticNormal(A,B):
# A_ij = sum_k=(1,n)  [A_ik*B_kj]          
    for i in range(np.size(A,0)):
        for j in range (np.size(A,0)):                   
            C[i][j] = np.sum(A[i][:]*B[:][j])        
    return C

@jit
def NasobeniMaticJIT(A,B):
# A_ij = sum_k=(1,n)  [A_ik*B_kj]          
    for i in range(np.size(A,0)):
        for j in range (np.size(A,0)):                   
            C[i][j] = np.sum(A[i][:]*B[:][j])        
    return C

@vectorize
def NasobeniMaticVect(A,B):
# A_ij = sum_k=(1,n)  [A_ik*B_kj]          
    for i in range(np.size(A,0)):
        for j in range (np.size(A,0)):                   
            C[i][j] = np.sum(A[i][:]*B[:][j])        
    return C


# pre-allocate fields
N=int(400)
#A(m,n)
A = np.random.randint(low=1, high=5,size=(N,N)) 
#B(n,p)
B = np.random.randint(low=1, high=5,size=(N,N))
#C(m,p)
C = np.zeros((np.size(A,0),np.size(B,1)))

tic=time.time()
C = np.matmul(A,B)
toc=time.time()
print('elapsed time numpy',toc-tic)

tic=time.time()
C1 = NasobeniMaticNormal(A,B)
toc=time.time()
print('elapsed time function',toc-tic)

tic=time.time()
C2 = NasobeniMaticNormal(A,B)
toc=time.time()
print('elapsed time jit-function',toc-tic)

tic=time.time()
C3 = NasobeniMaticNormal(A,B)
toc=time.time()
print('elapsed time vect-function',toc-tic)


"""
print(A,'\n\n',B,'\n\n',C,'\n\n')
print('funkce\n',C1,'\n\n')
print('jit funkce\n',C2,'\n\n')
print('vect funkce\n',C3,'\n\n')
"""

